unit Samdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus, SysUtils,
  StdCtrls, Buttons,  Dialogs, ExtCtrls, AdDialog;


type
  TSDIAppForm = class(TForm)
    StandardDLG: TBitBtn;
    AdrockDLG: TBitBtn;
    GroupBox1: TGroupBox;
    ButtonYes: TCheckBox;
    ButtonNo: TCheckBox;
    ButtonCancel: TCheckBox;
    ButtonAbort: TCheckBox;
    ButtonRetry: TCheckBox;
    ButtonIgnore: TCheckBox;
    ButtonOK: TCheckBox;
    ButtonALL: TCheckBox;
    ButtonHelp: TCheckBox;
    GroupBox2: TGroupBox;
    AutoTimer: TEdit;
    GroupBox3: TGroupBox;
    DefaultYes: TRadioButton;
    DefaultNo: TRadioButton;
    DefaultCancel: TRadioButton;
    DefaultAbort: TRadioButton;
    DefaultRetry: TRadioButton;
    DefaultIgnore: TRadioButton;
    DefaultOK: TRadioButton;
    DefaultALL: TRadioButton;
    GroupBox4: TGroupBox;
    SoundNone: TRadioButton;
    SoundICONAsterisk: TRadioButton;
    SoundIconExclamation: TRadioButton;
    GroupBox5: TGroupBox;
    CursorDoNotMove: TRadioButton;
    CursorMove: TRadioButton;
    SoundIconHand: TRadioButton;
    SoundIconQuestion: TRadioButton;
    SoundOK: TRadioButton;
    Label1: TLabel;
    GroupBox6: TGroupBox;
    StylemtInformation: TRadioButton;
    StylemtConfimation: TRadioButton;
    StylemtWarning: TRadioButton;
    StyleMtError: TRadioButton;
    GetMessage: TEdit;
    WaveFileName: TEdit;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    WaveFileRadioButton: TRadioButton;
    procedure StandardDLGClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure AdrockDLGClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure WaveFileNameChange(Sender: TObject);
  private
    { Private declarations }
    Procedure ShowMessageResult(Result : Word);
  public
    { Public declarations }
    Function GetButtons : TMsgDlgButtons;
    Function GetDefaultButton : TMsgDlgBtn;
    Function GetSound:Integer;
    Function GetStyle : TMsgDlgType;
  end;

var
  SDIAppForm: TSDIAppForm;

implementation

{$R *.DFM}

procedure TSDIAppForm.StandardDLGClick(Sender: TObject);
begin
     MessageDlg(getmessage.Text, GetStyle, GetButtons, 0);
end;

procedure TSDIAppForm.BitBtn2Click(Sender: TObject);
begin
     InformationBox('#2, That will overwrite your data?');
end;

procedure TSDIAppForm.BitBtn3Click(Sender: TObject);
begin
     QueryBox('#3, Are you sure that you want to format your hard drive?', mbNo);
end;

procedure TSDIAppForm.BitBtn4Click(Sender: TObject);
begin
     ShowMessageResult(MessageDialog('#4, Are you sure that you want to format your hard drive?',
     mtConfirmation, [mbAll, MbYes, MbNo, MbCancel, mbAbort, mbOK, mbRetry, mbIgnore, mbHelp],
     MbNo, MB_ICONEXCLAMATION, 5000, 0));
end;

procedure TSDIAppForm.AdrockDLGClick(Sender: TObject);
begin
     SetMessageDialogCursor((CursorDoNotMove.Checked = FALSE), FALSE);
     if (WaveFileRadioButton.Checked= TRUE)then
       ShowMessageResult(MessageDialogWave(getmessage.Text, getStyle,
         GetButtons, GetDefaultButton, WaveFileName.Text, StrToInt(AutoTimer.Text), 0))
     else
       ShowMessageResult(MessageDialog(getmessage.Text, getStyle,
         GetButtons, GetDefaultButton, GetSound, StrToInt(AutoTimer.Text), 0));
end;

Function TSDIAppForm.GetStyle : TMsgDlgType;
begin
 if (StylemtInformation.Checked = TRUE) then
    Result := mtInformation
 else if (StylemtConfimation.Checked = TRUE) then
    Result := MtConfirmation
 else if (StylemtWarning.Checked = TRUE) then
    Result := mtWarning
 else
    Result := mtError;
end;

Function TSDIAPpForm.GetButtons : TMsgDlgButtons;
Var
  Res : TMsgDlgButtons;
begin
  Res := [];
  if (ButtonYes.Checked = TRUE) then
    Res := Res + [mbYes];
  if (ButtonNo.Checked = TRUE) then
    Res := Res + [mbNo];
  if (ButtonCancel.Checked = TRUE) then
    Res := Res + [mbCancel];
  if (ButtonAbort.Checked = TRUE) then
    Res := Res + [mbAbort];
  if (ButtonRetry.Checked = TRUE) then
    Res := Res + [mbRetry];
  if (ButtonIgnore.Checked = TRUE) then
    Res := Res + [mbIgnore];
  if (ButtonOK.Checked = TRUE) then
    Res := Res + [mbOK];
  if (ButtonAll.Checked = TRUE) then
    Res := Res + [mbAll];
  if (ButtonHelp.Checked = TRUE) then
    Res := Res + [mbHelp];
  Result := RES;
end;

Function TSDIAppForm.GetDefaultButton : TMsgDlgBtn;
begin
     if (DefaultYes.Checked = TRUE) then
      result := mbYes
     else if (DefaultNo.Checked = TRUE) then
      result := mbNo
     else if (DefaultCancel.Checked = TRUE) then
      result := mbCancel
     else if (DefaultAbort.Checked = TRUE) then
      result := mbAbort
     else if (DefaultRetry.Checked = TRUE) then
      result := mbRetry
     else if (DefaultIgnore.Checked = TRUE) then
      result := mbIgnore
     else if (DefaultOK.Checked = TRUE) then
      result := mbOK
     else
      result := mbAll;
end;


Function TSDIAppForm.GetSound:Integer;
begin
  if (SoundNone.Checked = TRUE) then
   result := -1
  else if (SoundICONAsterisk.Checked = TRUE) then
    Result := MB_ICONASTERISK
  else if (SoundIconExclamation.Checked = TRUE) then
    Result := MB_ICONEXCLAMATION
  else if (SoundIconhAND.Checked = TRUE) then
    Result := MB_ICONHAND
  else if (SoundIconQuestion.Checked = TRUE) then
    Result := MB_ICONQuestion
  else
    Result := MB_OK;
end;

Procedure TSdiAppForm.ShowMessageResult(Result : Word);
begin
   Case Result of
     mrYes    : informationBox('mrYes');
     mrNo     : informationBox('mrNo');
     mrOK     : informationBox('mrOK');
     mrCancel : informationBox('mrCancel');
     mrAbort  : informationBox('mrAbort');
     mrRetry  : informationBox('mrRetry');
     mrIgnore : informationBox('mrIgnore');
     mrAll    : informationBox('mrAll');
   end;
end;

procedure TSDIAppForm.SpeedButton1Click(Sender: TObject);
begin
  OpenDialog1.FileName := WaveFileName.Text;
  if (OpenDialog1.Execute = TRUE) then
   begin
     WaveFileRadioButton.Checked := TRUE;
     WaveFileName.Text := OpenDialog1.FileName;
   end;
end;

procedure TSDIAppForm.WaveFileNameChange(Sender: TObject);
begin
       WaveFileRadioButton.Checked := TRUE;
end;

end.

